 /* '02 Game.cpp' */

 /* Komplementarny plik nagwka CGame */
#include "02 Game.h"

 /* Zainicjuj skadniki stanami pocztkowymi */
CGame::CGame ()
{
 m_Console    = NULL;
 m_GameStatus = GameSplashScreen;
 m_LastAction = 0;
 m_Monsters   = NULL;
}
 
 /* Zainicjuj skadniki stanami pocztkowymi informacji konsoli */
CGame::CGame (ConLib * Console)
{
 m_Console    = Console;
 m_GameStatus = GameSplashScreen;
 m_LastAction = 0;
 m_Monsters   = NULL;
}

 /* Domylny destruktor */
CGame::~CGame ()
{
 m_Console    = NULL;
 m_GameStatus = GameSplashScreen;
 m_LastAction = 0;
 m_Monsters   = NULL;
}

 /* Ustawia wskanik do konsoli */
void CGame::SetConsole (ConLib * Console)
{
 m_Console    = Console;
}

 /* Zwraca status gry */
int CGame::GetStatus (void)
{
 return m_GameStatus;
}


 /* Pokazuje ekran powitalny z instrukcj gry */
void CGame::ShowSplash (void)
{
 m_Console->Clear ();
 m_Console->OutputString ("\tWitaj w grze Potwor 1.0 \n\n");
 m_Console->OutputString ("Gra w Potwora jest bardzo prosta. \n\n");

 m_Console->OutputString ("Celem gry jest zabicie wszystkich \n");
 m_Console->OutputString ("potworow. Dwa lub wiecej potworow \n");
 m_Console->OutputString ("ginie, kiedy znajda sie na tym samym \n");
 m_Console->OutputString ("polu. Ty rowniez tracisz zycie \n");
 m_Console->OutputString ("jezeli znajdziesz sie na polu, \n");
 m_Console->OutputString ("na ktorym jest potwor. Poruszasz sie \n");
 m_Console->OutputString ("za pomoca klawiatury numerycznej w osmiu \n");
 m_Console->OutputString ("mozliwych kierunkach. Kiedy nacisniesz \n");
 m_Console->OutputString ("Insert wykonasz skok na losowe miejsce \n");
 m_Console->OutputString ("planszy.\n\n");

 m_Console->SetTextColor (ConRed);
 m_Console->OutputString ("NOTE: Aby grac wylacz NumLock.\n\n");
 m_Console->SetTextColor (ConRed | ConGreen | ConBlue);

 m_Console->OutputString ("Dostepne sa trzy poziomy trudnosci::\n\n");
 m_Console->OutputString (" Latwy  :  Potwory  = 10   Arena = 25*15\n");
 m_Console->OutputString ("           Zycia    = 4    Skoki = 3\n");
 m_Console->OutputString (" Sredni :  Potwory  = 20   Arena = 35*18\n");
 m_Console->OutputString ("           Zycia    = 3    Skoki = 2\n");
 m_Console->OutputString (" Trudny :  Potwory  = 30   Arena = 50*23\n");
 m_Console->OutputString ("           Zycia    = 2    Skoki = 1");
}

 /* Ukazuje gwne menu */
void CGame::ShowMenu (void)
{
 COORD Position;

 m_Console->SetBackgroundColor (0);
 m_Console->SetTextColor (ConRed);
 m_Console->Clear ();

 m_Console->SetBackgroundColor (ConRed | ConGreen | ConBlue);

 m_Console->OutputString ("                                        \n");
 m_Console->OutputString ("         Potwor - wersja 1.0          \n");
 m_Console->OutputString ("                                        ");

 m_Console->SetBackgroundColor (0);
 m_Console->SetTextColor (ConRed | ConGreen | ConBlue);

 Position.X = 1;
 Position.Y = 4;
 m_Console->SetPosition (Position);
 m_Console->OutputString ("Co wybierasz?: ");
 
 Position.X = 3;
 Position.Y = 6;
 m_Console->SetPosition (Position);
 m_Console->OutputString ("1 - Zacznij nowa gra - latwy poziom");
 Position.Y = 7;
 m_Console->SetPosition (Position);
 m_Console->OutputString ("2 - Zacznij nowa gra - sredni poziom");
 Position.Y = 8;
 m_Console->SetPosition (Position);
 m_Console->OutputString ("3 - Zacznij nowa gra - trudny poziom");

 Position.Y = 10;
 m_Console->SetPosition (Position);
 m_Console->OutputString ("Q - Wyjscie");
}

 /* Pokazuje ekran gry */
void CGame::ShowGame (void)
{
 COORD Position;
 int Monster;

  /* Rysuje pozycje gracza */
 m_Console->SetBackgroundColor (0);
 m_Console->SetTextColor (ConGreen);

 m_Player.GetPosition (&Position);

 m_Console->SetPosition (Position);
 m_Console->OutputString ("P");

  /* Rysuje plansze */
 int FieldX, FieldY;
 m_Console->SetBackgroundColor (ConRed | ConGreen | ConBlue);
 m_Console->SetTextColor (ConRed | ConGreen | ConBlue);

 for (FieldY = 0; FieldY <= m_Arena.Y; FieldY++)
 {
  if ( (FieldY == 0) || (FieldY == m_Arena.Y) )
  {
   for (FieldX = 0; FieldX <= m_Arena.X; FieldX++)
   {
    Position.X = FieldX;
    Position.Y = FieldY;
    m_Console->SetPosition (Position);
    m_Console->OutputString ("#");
   }
  }
  else
  {
   Position.X = 0;
   Position.Y = FieldY;
   m_Console->SetPosition (Position);
   m_Console->OutputString ("#");
   Position.X = m_Arena.X;
   Position.Y = FieldY;
   m_Console->SetPosition (Position);
   m_Console->OutputString ("#");
  }
 }

  /* Rysuje potwory */
 m_Console->SetBackgroundColor (0);
 m_Console->SetTextColor (ConRed);
 for (Monster = 0; Monster < m_MonstersNumber; Monster++)
 {
  if (m_Monsters [Monster].X != 0)
  {
   m_Console->SetPosition (m_Monsters [Monster]);
   m_Console->OutputString ("M");
  }
 }

  /* Pokazuje wynik i ilo y */
 char Buffer [100];

 sprintf (Buffer, "  Zycia: %d \t\t Wynik: %d \t Skoki: %d", 
          m_Player.GetLives () - 1, m_Player.GetScore (), 
          m_Player.GetLeaps ());
 Position.X = 5;
 Position.Y = 24;
 m_Console->SetPosition (Position);
 m_Console->SetTextColor (ConRed | ConGreen | ConRed);
 m_Console->OutputString (Buffer);
}

 /* Pokazuje okno wygranej */
void CGame::ShowWon (void)
{
 ShowGame ();

 COORD Position;

 Position.X = 20;
 Position.Y = 11;
 m_Console->SetPosition (Position);

 m_Console->SetBackgroundColor (ConGreen);
 m_Console->SetTextColor (ConRed);

 m_Console->OutputString ("########################################");
 Position.Y = 12;
 m_Console->SetPosition (Position);
 m_Console->OutputString ("#            Gratulacje!               #");
 Position.Y = 13;
 m_Console->SetPosition (Position);
 m_Console->OutputString ("#      Zabiles wszystkie potwory   .   #");
 Position.Y = 14;
 m_Console->SetPosition (Position);
 m_Console->OutputString ("########################################");
}

 /* Pokazuje okna utraty ycia */
void CGame::ShowLostLife (void)
{
 ShowGame ();

 COORD Position;

 Position.X = 20;
 Position.Y = 11;
 m_Console->SetPosition (Position);

 m_Console->SetBackgroundColor (ConGreen);
 m_Console->SetTextColor (ConRed);

 m_Console->OutputString ("########################################");
 Position.Y = 12;
 m_Console->SetPosition (Position);
 m_Console->OutputString ("#          Staciles zycie              #");
 Position.Y = 13;
 m_Console->SetPosition (Position);
 m_Console->OutputString ("########################################");
}

 /* Pokazuje okno przegranej */
void CGame::ShowLost (void)
{
 ShowGame ();

 COORD Position;

 Position.X = 20;
 Position.Y = 11;
 m_Console->SetPosition (Position);

 m_Console->SetBackgroundColor (ConGreen);
 m_Console->SetTextColor (ConRed);

 m_Console->OutputString ("########################################");
 Position.Y = 12;
 m_Console->SetPosition (Position);
 m_Console->OutputString ("#             Niestety!                #");
 Position.Y = 13;
 m_Console->SetPosition (Position);
 m_Console->OutputString ("#     Straciles wszystkie zycia   .    #");
 Position.Y = 14;
 m_Console->SetPosition (Position);
 m_Console->OutputString ("########################################");
}

 /* Pokazuje komunikat przy wyjciu z gry */
void CGame::ShowExit (void)
{
 m_Console->SetBackgroundColor (0);
 m_Console->SetTextColor (ConRed | ConGreen | ConBlue);
 m_Console->Clear ();
 m_Console->OutputString ("\n   Potwor 1.0 \n\n\n");
 m_Console->OutputString (" by: Bruno Sousa (bsousa@fireworks");
 m_Console->OutputString ("-interactive.com)\n\n\n\n");
 m_Console->OutputString ("Dzieki za gre!\n\n\n");
 m_Console->OutputString ("I pamietaj, trzymaj sie z dala od dragow.\n\n");
}

 /* Pokazuje odpowiedni ekran w zalenoci od statusu gry */
void CGame::Show (void)
{
 m_Console->SetBackgroundColor (0);
 m_Console->SetTextColor (ConRed | ConGreen | ConBlue);
 m_Console->Clear ();

 switch (m_GameStatus)
 {
 case GameMainMenu:
  ShowMenu ();
 break;

 case GameRunning:
  ShowGame ();
  break;

 case GameWon:
  ShowWon ();
  break;

 case GameLostLife:
  ShowLostLife ();
  break;

 case GameLost:
  ShowLost ();
  break;

 case GameExit:
  ShowExit ();
  break;

 case GameSplashScreen:
  ShowSplash ();
  break;

 default:
  break;
 }
}

 /* Rozpoczyna now gr */
void CGame::StartNewGame (int Difficulty)
{
 int Monster;

 COORD Position;
 
 m_GameStatus = GameRunning;

  /* Ustawia poziom trudnoci */
 switch (Difficulty)
 {
 case GameEasy:
  m_MonstersNumber = 10;
  m_Player.SetLives (4);
  m_Player.SetLeaps (3);
  m_Arena.X = 25;
  m_Arena.Y = 15;
  break;
 case GameMedium:
  m_MonstersNumber = 25;
  m_Player.SetLives (3);
  m_Player.SetLeaps (2);
  m_Arena.X = 35;
  m_Arena.Y = 18;
  break;
 case GameDifficult:
  m_MonstersNumber = 35;
  m_Player.SetLives (2);
  m_Player.SetLeaps (1);
  m_Arena.X = 50;
  m_Arena.Y = 23;
  break;
 }

  /* Tworzy gracza */
 m_Player.RandomLeap (m_Arena);
 m_Player.GetPosition (&Position);
 m_Player.SetScore (0);

  /* Tworzy potwory */
 m_Monsters = new COORD [m_MonstersNumber];
 srand (time (NULL));

  /* Oblicza losow pozycj potworw */
 for (Monster = 0; Monster < m_MonstersNumber; Monster++)
 {
   /* Upewnia si, e pozycje te rni si od pozycji gracza */
  do 
  {
   m_Monsters [Monster].X = (rand () % (m_Arena.X - 1)) + 1;
   m_Monsters [Monster].Y = (rand () % (m_Arena.Y - 1)) + 1;
  }
  while ( (m_Monsters [Monster].X == Position.X) && 
          (m_Monsters [Monster].Y == Position.Y) );
 }
}

 /* Wykrywa dziaanie gracza */
int CGame::GetAction (void)
{ 
  /* Pobranie danych wejciowych od uytkownika */
 m_LastAction = m_Console->GetKey ();

 return m_LastAction;
}

 /* Przesunicie potworw zgodnie z pozycj gracza */
void CGame::MoveMonsters (void)
{
 COORD Distance, Position;
 int Monster;

 m_Player.GetPosition (&Position);

 for (Monster = 0; Monster < m_MonstersNumber; Monster++)
 {
   /* Sprawdzenie czy potwr jest martwy */
  if (m_Monsters [Monster].X != 0)
  {
   Distance.X = Position.X - m_Monsters [Monster].X;
   Distance.Y = Position.Y - m_Monsters [Monster].Y;

    /* Upewnienie si, e potwr przesun si tylko o jedno pole */
   if (Distance.X > 0)
   {
    Distance.X = 1;
   }
   if (Distance.X < 0)
   {
    Distance.X = -1;
   }
   if (Distance.Y > 0)
   {
    Distance.Y = 1;
   }
   if (Distance.Y < 0)
   {
    Distance.Y = -1;
   }
   
    /* Przemie potwory */
   m_Monsters [Monster].X += Distance.X;
   m_Monsters [Monster].Y += Distance.Y;
  }
 }
}


 /* Przetwarzanie ekranu powitalnego */
void CGame::ProcessSplash (void)
{
  /* Jeeli uytkownik nacisn klawisz, przejd do gwnego menu */
 if (m_LastAction)
 {
  m_GameStatus = GameMainMenu;
 }
}

 /* Pobiera opj z menu i albo wychodzi albo rozpoczyna now gr  */
void CGame::ProcessMenu (void)
{
 switch (m_LastAction)
 {
  /* Wychodzi z gry */
 case VK_ESCAPE:
 case 'Q':
 case 'q':
  m_GameStatus = GameExit;
  break;

  /* Rozpoczyna now gr */
 case '1':
  StartNewGame (GameEasy);
  m_GameStatus = GameRunning;
  break;
 case '2':
  StartNewGame (GameMedium);
  m_GameStatus = GameRunning;
  break;
 case '3':
  StartNewGame (GameDifficult);
  m_GameStatus = GameRunning;
  break;

 default:
  break;
 }
}

 /* Przemieszcza potwory i gracza */
void CGame::ProcessGame (void)
{
 COORD Movement;
 int Monster, MonstersAlive;

 Movement.X = 0;
 Movement.Y = 0;

  /* Przemieszcza gracza */
 switch (m_LastAction)
 { 
 case VK_UP:
  Movement.Y = -1;
  break;
 case VK_DOWN:
  Movement.Y = 1;
  break;
 case VK_LEFT:
  Movement.X = -1;
  break;
 case VK_RIGHT:
  Movement.X = 1;
  break;

 case VK_HOME:
  Movement.X = -1;
  Movement.Y = -1;
  break;
 case VK_PRIOR:
  Movement.X = 1;
  Movement.Y = -1;
  break;
 case VK_END:
  Movement.X = -1;
  Movement.Y = 1;
  break;
 case VK_NEXT:
  Movement.X = 1;
  Movement.Y = 1;
  break;
 case VK_INSERT:
  if (m_Player.GetLeaps () > 0)
  {
   m_Player.RandomLeap (m_Arena);
   m_Player.SetLeaps (m_Player.GetLeaps () - 1);
  }
  break;
 case VK_ESCAPE:
  EndGame ();
  m_GameStatus = GameMainMenu;
  break;
 }

  /* By ruch */
 if ( (Movement.X != 0) || (Movement.Y != 0) )
 {
  COORD PlayerPosition;
  m_Player.GetPosition (&PlayerPosition);

   /* Jeeli ruch dokona si w obrbie planszy */
  if ( (Movement.X + PlayerPosition.X > 0) && 
       (Movement.Y + PlayerPosition.Y > 0) &&
       (Movement.X + PlayerPosition.X < m_Arena.X) &&
       (Movement.Y + PlayerPosition.Y < m_Arena.Y) )
  {
   m_Player.Move (Movement);
  }

   /* Wykonaj AI potworw i sprawd kolizje */
  MoveMonsters ();
  CheckCollisions ();

   /* Sprawd, czy jaki potwr jeszcze yje */
  MonstersAlive = 0;
  for (Monster = 0; Monster < m_MonstersNumber; Monster ++)
  {
    /* Sprawd czy potwr jest martwy */
   if (m_Monsters [Monster].X != 0)
   {
    MonstersAlive = 1;
    break;
   }
  }
  if (MonstersAlive == 0)
  {
   m_GameStatus = GameWon;
  }
 }
}

 /* Sprawd kolizje pomidzy potworami a graczem */
void CGame::CheckCollisions ()
{
 COORD Position;
 int MonsterA, MonsterB;

 m_Player.GetPosition (&Position);

 for (MonsterA = 0; MonsterA < m_MonstersNumber; MonsterA ++)
 {
   /* Sprawd czy potwr jest martwy */
  if (m_Monsters [MonsterA].X != 0)
  {
    /* Sprawd czy wystpuje kolizja z graczem*/
   if ( (m_Monsters [MonsterA].X == Position.X) &&
        (m_Monsters [MonsterA].Y == Position.Y) )
   {
    m_Monsters [MonsterA].X = 0;
    m_Monsters [MonsterA].Y = 0;

     /* Sprawd czy gracz ma jeszcze jakie ycia */
    if (m_Player.GetLives () - 1 <= 0)
    {
     m_GameStatus = GameLost;
    }
    else
    {
     m_GameStatus = GameLostLife;
    }
    return;
   }
    /* Sprawd kolizje pomidzy potworami */
   for (MonsterB = MonsterA+1; MonsterB < m_MonstersNumber; MonsterB++)
   {
     /* Sprawd czy potwr nie yje */
    if (m_Monsters [MonsterB].X != 0)
    {
      /* Sprawd kolizje z innymi potworami */
     if ( (m_Monsters [MonsterA].X == m_Monsters [MonsterB].X) &&
          (m_Monsters [MonsterA].Y == m_Monsters [MonsterB].Y) )
     {
      m_Monsters [MonsterA].X = m_Monsters [MonsterB].X = 0;
      m_Monsters [MonsterA].Y = m_Monsters [MonsterB].Y = 0;
      m_Player.SetScore (m_Player.GetScore () + 15);
     }
    }
   }
  }
 }
}

 /* Zakocz gr i powr do gwnego menu */
void CGame::ProcessWon (void)
{
  /* Jeeli uytkownik nacisn klawisz, przejd do gwnego menu */
 if (m_LastAction)
 {
  m_GameStatus = GameMainMenu;
 }

 EndGame ();
}

 /* Zakocz gr */
void CGame::EndGame (void)
{
 if (m_Monsters != NULL)
 {
  delete [] m_Monsters;
 }
 m_Monsters = NULL;
}

 /* Odejmuje graczowi ycie */
void CGame::ProcessLostLife (void)
{
 int IsValid = 0;
 int Monster;
 COORD Position;

  /* Odejmij ycie graczowi i jeeli nie ma ju wicej, zakocz gr */
 m_Player.SetLives (m_Player.GetLives () - 1);
 if (m_Player.GetLives () - 1 <= -1)
 {
  m_GameStatus = GameLost;
 }
 else
 {
  m_GameStatus = GameRunning;
  IsValid = 0;
   /* Oblicz losow pozycj dla gracza */
  do 
  {
   m_Player.RandomLeap (m_Arena);
   m_Player.GetPosition (&Position);
  
    /* Upewnij si, e pozycja ta rni si od pozycji potworw */
   for (Monster = 0; Monster < m_MonstersNumber; Monster++)
   {
     /* Sprawd czy potwr nie yje */
    if (m_Monsters [Monster].X != 0)
    {
     if ( (m_Monsters [Monster].X != Position.X) &&
          (m_Monsters [Monster].Y != Position.Y) )
     {
      IsValid = 1;
     }
     else
     {
      IsValid = 0;
     }
    }
   }
  }
  while ( IsValid == 0 );
 }
}

 /* Zakocz gr i powr do gwnego menu */
void CGame::ProcessLost (void)
{
  /* Jeeli uytkownik nacisn klawisz, przejd do gwnego menu */
 if (m_LastAction)
 {
  m_GameStatus = GameMainMenu;
 }

 EndGame ();
 Show ();
}

 /* Oglna funkcja, ktra wykonuje wszystkie zadania w biecej rundzie */
void CGame::Process (void)
{
  /* Jako, e ekran powitalny musi by pokazany na pocztku,
     wymuszamy jego ukazanie, poniewa nie ma adnych oczekujcych wydarze */
 if (m_GameStatus == GameSplashScreen)
 {
  Show ();
 }

  /* Jeeli uytkownik nacinie klawisz, reaguj w odpowiedni sposb */
 if (GetAction ())
 {
  switch (m_GameStatus)
  {
  case GameMainMenu:
   ProcessMenu ();
   break;

  case GameRunning:
   ProcessGame ();
   break;

  case GameWon:
   ProcessWon ();
   break;

  case GameLostLife:
   ProcessLostLife ();
   break;

  case GameLost:
   ProcessLost ();
   break;

  case GameSplashScreen:
   ProcessSplash ();
   break;

  default:
   break;
  }
  Show ();
 }
}